/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorMap;
import filenet.sim.toolkit.viewer.VWSIMAnimatorScenario;
import filenet.sim.toolkit.viewer.VWSIMAnimatorStep;
import filenet.sim.toolkit.viewer.VWSIMAnimatorWorkflow;
import filenet.sim.toolkit.viewer.images.VWSIMImageLoader;
import filenet.sim.toolkit.viewer.resources.VWSIMResource;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class VWSIMAnimatorTreePane
extends JPanel
implements TreeSelectionListener,
ItemSelectable,
FocusListener,
ItemListener {
    protected Frame m_parentFrame = null;
    private DefaultMutableTreeNode m_rootNode = null;
    private JTree m_tree = null;
    private Vector m_allNodes = new Vector();
    private boolean m_bTreeInitialized = false;
    private VWTreeCellRenderer m_treeCellRenderer = null;
    private VWSIMAnimatorTreeMouseAdapter m_mouseAdapter = null;
    private boolean m_bHasFocus = false;
    private VWSIMAnimatorMap m_selectedMap = null;
    private VWSIMAnimatorDataModel m_dataModel = null;
    protected ItemListener m_selectListeners = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWSIMAnimatorTreePane(Frame parentFrame, VWSIMAnimatorDataModel dataModel) {
        this.m_parentFrame = parentFrame;
        this.m_dataModel = dataModel;
        VWSIMAnimatorTreePane vWSIMAnimatorTreePane = this;
        synchronized (vWSIMAnimatorTreePane) {
            this.initData();
            this.setupLayout();
        }
    }

    public void addNotify() {
        Vector maps;
        super.addNotify();
        if (this.m_dataModel != null && (maps = this.m_dataModel.getAllMaps()) != null && maps.size() > 0) {
            DefaultMutableTreeNode node;
            Object[] path;
            Object obj = maps.elementAt(0);
            if (obj != null && obj instanceof VWSIMAnimatorMap && (path = (node = this.findTreeNode((VWSIMAnimatorMap)obj)).getPath()) != null) {
                TreePath treePath = new TreePath(path);
                this.m_tree.setSelectionPath(treePath);
                this.m_tree.expandPath(treePath);
            }
            maps.removeAllElements();
            Object var1_1 = null;
        }
        this.m_bTreeInitialized = true;
    }

    private DefaultMutableTreeNode newTreeNode(Object userObject) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(userObject);
        this.m_allNodes.add(node);
        return node;
    }

    protected void initData() {
        if (this.m_dataModel != null) {
            VWSIMAnimatorScenario scenario = this.m_dataModel.getScenario();
            this.m_rootNode = scenario != null ? new DefaultMutableTreeNode(scenario) : new DefaultMutableTreeNode(VWSIMResource.s_workflows);
            Vector workflows = this.m_dataModel.getWorkflows();
            if (workflows != null) {
                Object obj = null;
                VWSIMAnimatorWorkflow workflow = null;
                VWSIMAnimatorMap map = null;
                DefaultMutableTreeNode workflowNode = null;
                DefaultMutableTreeNode mapNode = null;
                for (int i = 0; i < workflows.size(); ++i) {
                    obj = workflows.elementAt(i);
                    if (obj == null || !(obj instanceof VWSIMAnimatorWorkflow)) continue;
                    workflow = obj;
                    workflowNode = new DefaultMutableTreeNode(workflow);
                    this.m_rootNode.add(workflowNode);
                    Vector maps = workflow.getMaps();
                    if (maps == null) continue;
                    for (int j = 0; j < maps.size(); ++j) {
                        obj = maps.elementAt(j);
                        if (obj == null || !(obj instanceof VWSIMAnimatorMap)) continue;
                        map = obj;
                        mapNode = new DefaultMutableTreeNode(map);
                        if (i == 0 && j == 0) {
                            map.setSelected(true);
                            this.m_selectedMap = map;
                        }
                        workflowNode.add(mapNode);
                    }
                }
                Object var2_2 = null;
            }
        }
    }

    protected void setupLayout() {
        Vector maps;
        this.setLayout(new BorderLayout());
        JTree tree = new JTree(this.m_rootNode);
        this.add(new JScrollPane(tree));
        ToolTipManager.sharedInstance().registerComponent(tree);
        this.m_mouseAdapter = new VWSIMAnimatorTreeMouseAdapter(tree);
        tree.addMouseListener(this.m_mouseAdapter);
        this.m_treeCellRenderer = new VWTreeCellRenderer();
        tree.setCellRenderer(this.m_treeCellRenderer);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(this);
        tree.addFocusListener(this);
        this.m_tree = tree;
        if (this.m_dataModel != null && (maps = this.m_dataModel.getAllMaps()) != null && maps.size() > 0) {
            DefaultMutableTreeNode node;
            Object[] path;
            Object obj = maps.elementAt(0);
            if (obj != null && obj instanceof VWSIMAnimatorMap && (path = (node = this.findTreeNode((VWSIMAnimatorMap)obj)).getPath()) != null) {
                TreePath treePath = new TreePath(path);
                this.m_tree.setSelectionPath(treePath);
                this.m_tree.expandPath(treePath);
            }
            maps.removeAllElements();
            Object var2_2 = null;
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object nodeInfo = this.getSelectedObject();
        if (nodeInfo == null || nodeInfo instanceof VWSIMAnimatorMap) {
            // empty if block
        }
    }

    public synchronized void addItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, l);
    }

    public void notifySelectListeners() {
        Object nodeInfo = this.getSelectedObject();
        if (nodeInfo != null && nodeInfo instanceof VWSIMAnimatorMap) {
            ItemEvent event;
            if (this.m_selectedMap != null) {
                this.m_selectedMap.setSelected(false);
                event = new ItemEvent(this, 0, this.m_selectedMap, 2);
                if (this.m_selectListeners != null) {
                    this.m_selectListeners.itemStateChanged(event);
                }
            }
            this.m_selectedMap = (VWSIMAnimatorMap)nodeInfo;
            this.m_selectedMap.setSelected(true);
            event = new ItemEvent(this, 0, nodeInfo, 1);
            if (this.m_selectListeners != null) {
                this.m_selectListeners.itemStateChanged(event);
            }
            if (this.m_tree != null && this.m_bTreeInitialized) {
                this.m_tree.updateUI();
            }
        }
    }

    public void notifySelectListeners(Object obj) {
        if (obj == null) {
            this.notifySelectListeners();
        } else {
            Object nodeInfo = this.getSelectedObject();
            if (nodeInfo != null && nodeInfo instanceof VWSIMAnimatorMap) {
                ItemEvent event;
                if (this.m_selectedMap != null) {
                    this.m_selectedMap.setSelected(false);
                    event = new ItemEvent(this, 0, this.m_selectedMap, 2);
                    if (this.m_selectListeners != null) {
                        this.m_selectListeners.itemStateChanged(event);
                    }
                }
                this.m_selectedMap = (VWSIMAnimatorMap)nodeInfo;
                this.m_selectedMap.setSelected(true);
                event = new ItemEvent(this, 0, obj, 1);
                if (this.m_selectListeners != null) {
                    this.m_selectListeners.itemStateChanged(event);
                }
                if (this.m_tree != null && this.m_bTreeInitialized) {
                    this.m_tree.updateUI();
                }
            }
        }
    }

    public Object[] getSelectedObjects() {
        Object nodeInfo = this.getSelectedObject();
        if (nodeInfo != null && nodeInfo instanceof VWSIMAnimatorMap) {
            Object[] objects = null;
            objects = new Object[]{nodeInfo};
            return objects;
        }
        return null;
    }

    public boolean isMapNodeSelected() {
        Object nodeInfo = this.getSelectedObject();
        return nodeInfo != null && nodeInfo instanceof VWSIMAnimatorMap;
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    public void focusGained(FocusEvent e) {
        this.m_bHasFocus = true;
    }

    public void focusLost(FocusEvent e) {
        this.m_bHasFocus = false;
    }

    public void selectTreeNode(VWSIMAnimatorMap map) {
        DefaultMutableTreeNode node = this.findTreeNode(map);
        this.selectTreeNode(node);
    }

    public void deSelectTreeNode(VWSIMAnimatorMap map) {
        DefaultMutableTreeNode node = this.findTreeNode(map);
        this.deSelectTreeNode(node);
    }

    public void selectTreeNode(DefaultMutableTreeNode node) {
        Object[] path;
        if (node != null && (path = node.getPath()) != null) {
            TreePath treePath = new TreePath(path);
            this.m_tree.setSelectionPath(treePath);
            this.m_tree.expandPath(treePath);
        }
    }

    public void deSelectTreeNode(DefaultMutableTreeNode node) {
        Object[] path;
        if (node != null && (path = node.getPath()) != null) {
            TreePath treePath = new TreePath(path);
            this.m_tree.removeSelectionPath(treePath);
        }
    }

    public DefaultMutableTreeNode findTreeNode(VWSIMAnimatorMap map) {
        if (map != null) {
            DefaultMutableTreeNode node = this.m_rootNode;
            Object userObj = null;
            while (node != null) {
                if ((node = node.getNextNode()) == null || (userObj = node.getUserObject()) == null || !(userObj instanceof VWSIMAnimatorMap) || userObj != map) continue;
                return node;
            }
        }
        return null;
    }

    public synchronized void displayMap(VWSIMAnimatorMap map) {
        if (map != null) {
            DefaultMutableTreeNode node = this.m_rootNode;
            Object userObj = null;
            while (node != null) {
                if ((node = node.getNextNode()) == null || (userObj = node.getUserObject()) == null || !(userObj instanceof VWSIMAnimatorMap) || userObj != map) continue;
                Object[] path = node.getPath();
                if (path == null) break;
                TreePath treePath = new TreePath(path);
                this.m_tree.setSelectionPath(treePath);
                this.m_tree.expandPath(treePath);
                this.notifySelectListeners();
                break;
            }
        }
    }

    public synchronized void displayStep(VWSIMAnimatorStep step) {
        if (step != null) {
            VWSIMAnimatorMap map = step.getMap();
            if (map != null) {
                this.displayMap(map);
            }
            if (step != null) {
                this.notifySelectListeners(step);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getItem();
        if (obj != null) {
            if (obj instanceof VWSIMAnimatorMap) {
                this.displayMap((VWSIMAnimatorMap)obj);
            } else if (obj instanceof VWSIMAnimatorStep) {
                this.displayStep((VWSIMAnimatorStep)obj);
            } else if (obj instanceof VWSIMAnimatorWorkflow) {
                if (this.m_selectedMap.getWorkflow() == obj) {
                    return;
                }
                VWSIMAnimatorMap mainMap = ((VWSIMAnimatorWorkflow)obj).getMainMap();
                if (mainMap != null) {
                    this.displayMap(mainMap);
                }
            }
        }
    }

    public void releaseResources() {
        if (this.m_allNodes != null) {
            Object obj = null;
            for (int i = 0; i < this.m_allNodes.size(); ++i) {
                obj = this.m_allNodes.elementAt(i);
                if (obj == null || !(obj instanceof DefaultMutableTreeNode)) continue;
                ((DefaultMutableTreeNode)obj).removeFromParent();
                ((DefaultMutableTreeNode)obj).removeAllChildren();
                ((DefaultMutableTreeNode)obj).setUserObject(null);
            }
            this.m_allNodes.removeAllElements();
            this.m_allNodes = null;
        }
        this.m_parentFrame = null;
        this.m_rootNode = null;
        if (this.m_tree != null) {
            this.m_tree.removeAll();
            this.m_tree.setSelectionPath(null);
            this.m_tree.setCellRenderer(null);
            this.m_tree.removeTreeSelectionListener(this);
            this.m_tree.removeFocusListener(this);
            this.m_tree.removeMouseListener(this.m_mouseAdapter);
            this.m_tree = null;
        }
        if (this.m_treeCellRenderer != null) {
            this.m_treeCellRenderer.releaseResources();
            this.m_treeCellRenderer = null;
        }
        if (this.m_mouseAdapter != null) {
            this.m_mouseAdapter.releaseResources();
            this.m_mouseAdapter = null;
        }
        this.m_selectedMap = null;
        this.m_dataModel = null;
        this.m_selectListeners = null;
    }

    class VWSIMAnimatorTreeMouseAdapter
    extends MouseAdapter
    implements ActionListener {
        private JTree m_tree = null;
        private JPopupMenu m_popup = null;
        private JMenuItem m_selMapMenuItem = null;

        public VWSIMAnimatorTreeMouseAdapter(JTree tree) {
            this.m_tree = tree;
        }

        public void mousePressed(MouseEvent evt) {
            int selRow = this.m_tree.getRowForLocation(evt.getX(), evt.getY());
            this.m_tree.setSelectionRow(selRow);
            if (evt.isPopupTrigger()) {
                this.createPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.createPopup(evt);
            }
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object nodeInfo = node.getUserObject();
                if (node.isLeaf() && nodeInfo instanceof VWSIMAnimatorMap) {
                    VWSIMAnimatorTreePane.this.notifySelectListeners();
                    if (this.m_tree != null && VWSIMAnimatorTreePane.this.m_bTreeInitialized) {
                        this.m_tree.updateUI();
                    }
                }
            }
        }

        private void createPopup(MouseEvent evt) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                if (nodeInfo instanceof VWSIMAnimatorMap) {
                    this.createMapPopup(this.m_tree, evt);
                }
            } else if (nodeInfo instanceof VWSIMAnimatorWorkflow) {
                // empty if block
            }
        }

        private void createMapPopup(Container container, MouseEvent evt) {
            if (this.m_popup == null) {
                this.m_popup = new JPopupMenu();
            } else {
                this.m_popup.removeAll();
            }
            if (this.m_selMapMenuItem == null) {
                this.m_selMapMenuItem = new JMenuItem(VWSIMResource.s_displaySelectedMap);
                this.m_selMapMenuItem.addActionListener(this);
            }
            this.m_popup.add(this.m_selMapMenuItem);
            Point p = evt.getPoint();
            this.m_popup.show(container, p.x, p.y);
        }

        private void createWorkflowPopup(Container container, MouseEvent evt) {
            if (this.m_popup == null) {
                this.m_popup = new JPopupMenu();
            } else {
                this.m_popup.removeAll();
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.m_selMapMenuItem) {
                VWSIMAnimatorTreePane.this.notifySelectListeners();
            }
        }

        void releaseResources() {
            this.m_tree = null;
            if (this.m_popup != null) {
                this.m_popup.removeAll();
                this.m_popup = null;
            }
            if (this.m_selMapMenuItem != null) {
                this.m_selMapMenuItem.removeActionListener(this);
                this.m_selMapMenuItem = null;
            }
        }
    }

    class VWTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon m_scenarioIcon = VWSIMImageLoader.createImageIcon("scenario.gif");
        private ImageIcon m_workflowIcon = VWSIMImageLoader.createImageIcon("workflow.gif");
        private ImageIcon m_mapIcon = VWSIMImageLoader.createImageIcon("map.gif");
        private ImageIcon m_mapSelectedIcon = VWSIMImageLoader.createImageIcon("map_selected.gif");

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            component.setComponentOrientation(tree.getComponentOrientation());
            if (value != null) {
                Object nodeInfo = null;
                String text = null;
                if (value instanceof DefaultMutableTreeNode) {
                    nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
                }
                if (nodeInfo != null) {
                    if (nodeInfo instanceof VWSIMAnimatorScenario) {
                        this.setIcon(this.m_scenarioIcon);
                        text = ((VWSIMAnimatorScenario)nodeInfo).toString();
                    }
                    if (nodeInfo instanceof VWSIMAnimatorWorkflow) {
                        this.setIcon(this.m_workflowIcon);
                        text = ((VWSIMAnimatorWorkflow)nodeInfo).toString();
                    } else if (nodeInfo instanceof VWSIMAnimatorMap) {
                        text = ((VWSIMAnimatorMap)nodeInfo).toString();
                        if (((VWSIMAnimatorMap)nodeInfo).isSelected()) {
                            this.setIcon(this.m_mapSelectedIcon);
                        } else {
                            this.setIcon(this.m_mapIcon);
                        }
                    }
                    this.setText(text);
                    this.setToolTipText(text);
                }
                return this;
            }
            return component;
        }

        void releaseResources() {
            this.m_scenarioIcon = null;
            this.m_workflowIcon = null;
            this.m_mapIcon = null;
            this.m_mapSelectedIcon = null;
        }
    }
}

